<?php

namespace App\Http\Controllers;

use App\Models\Channel;
use App\Models\OrderManagement;

use App\Models\OrderManagementDetail;
use App\Models\Product;
use App\Models\ProductPrice;
use App\Models\Category;
use App\Models\Shipper;
use App\Models\Shipment;
use App\Models\Shop;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Datatables;
use Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use DB;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;

class ShipmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //$data = [];
        //Session::put('itemArray',$data);
        $total_records = DB::table('order_managements')
            ->select(DB::raw('count(*) as total'))
            ->get();
        $group_status = DB::table('order_managements')
            ->select('order_status', DB::raw('count(*) as total'))
            ->orderBy('order_status', 'desc')
            ->groupBy('order_status')
            ->get();

        $channels = Channel::all();
        return view('seller.shipments.index', compact('total_records', 'group_status', 'channels'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            if (isset($request->status) && $request->status != null && $request->status != 'all') {
                $status = $request->status;


                $data = OrderManagement::with('channels')
                    ->leftJoin('users', 'order_managements.created_by', '=', 'users.id')
                    ->select('order_managements.*','users.username')
                    ->where('order_managements.seller_id', '=', Auth::user()->id)
                    ->where('order_managements.order_status',$status)
                    ->get();
            }else{
                $data = OrderManagement::with('channels')
                    ->leftJoin('users', 'order_managements.created_by', '=', 'users.id')
                    ->select('order_managements.*','users.username')
                    ->where('order_managements.seller_id', '=', Auth::user()->id)
                    ->get();
            }

            //$data = OrderManagement::latest()->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($row) {
                    return $row->id;
                })
                ->addColumn('channel', function ($row) {
                    if(!empty($row->channels->image) && file_exists(public_path($row->channels->image))) {
                        return '<span><img src="'.asset($row->channels->image).'" class="cutome_image" ></span> <br>'
                            .$row->channels->name;
                    }
                    return '<span><img src="'.asset('No-Image-Found.png').'" class="cutome_image" ></span><br>'
                        .$row->channels->name;
                })
                ->addColumn('shipping_cost', function ($row) {
                    if(!empty($row->shipping_cost)){
                        return 'Tk.'.$row->shipping_cost;
                    }
                })
                ->addColumn('in_total', function ($row) {
                    if(!empty($row->in_total)){
                        return 'Tk.'.$row->in_total;
                    }
                })
                ->addColumn('order_status', function ($row) {
                    if($row->order_status == 1){
                        return '<button type="button" class="btn btn-primary btn-sm">Pending</button>';
                    }
                    if($row->order_status == 2){
                        $shipment_btn = '<a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnShipment"><i class="fas fa-ambulance"></i></a>';

                        return '<button type="button" class="btn btn-success btn-sm">Processing</button>'.$shipment_btn;
                    }
                    if($row->order_status == 3){
                        $shipmentDetails = Shipment::select('id')->where('order_id',$row->id)->first();

                        if(isset($shipmentDetails)){
                            $shipment_id = $shipmentDetails->id;
                            $shipment_date = Carbon::parse($shipmentDetails->shipment_date)->format('d-M-Y');

                            return '<button type="button" class="btn btn-info btn-sm mb-1">Ready to Ship</button><br>
                            <button type="button" class="btn btn-warning btn-sm mb-1">Shipment Id : '.$shipment_id.'</button>
                            <button type="button" class="btn btn-warning btn-sm ">Date : '.$shipment_date.'</button>
                        ';
                        }
                    }
                    if($row->order_status == 4){
                        return '<button type="button" class="btn btn-warning btn-sm">Shipped</button>';
                    }
                })
                ->addColumn('payment_status', function ($row) {
                    if($row->payment_status == 0){
                        return '<button type="button" class="btn btn-danger btn-sm">Unpaid</button>';
                    }
                    if($row->payment_status == 1){
                        return '<button type="button" class="btn btn-success btn-sm">Paid</button>';
                    }
                })
                ->addColumn('created_by', function ($row) {
                    $created_at = Carbon::parse($row->created_at)->format('d-M-Y h:i:a');
                    $br="<br>";
                    return ''.$row->username.$br.$created_at.'';
                })
                ->addColumn('action', function ($row) {
                    if($row->order_status == 2){
                        $shipment_btn = '<a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnShipment"><i class="fas fa-warehouse"></i></a>';
                    }
                    else{
                        $shipment_btn = '';
                    }

                    return '<a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnUpdate"><i class="fas fa-pencil-alt"></i></a>
                        <span class="bg-red-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer BtnDelete" data-id="' . $row->id . '" data-order_id="' . $row->order_id . '"><i class="fas fa-trash-alt"></i></span>';
                })
                ->rawColumns(['checkbox','channel', 'order_status','payment_status','action', 'shipping_cost', 'in_total', 'created_by'])
                ->make(true);
        }
    }


    public function data1(Request $request)
    {
    
        if ($request->ajax()) {
            if (isset($request->status) && $request->status != null && $request->status != 'all') {
                $status = $request->status;
                $data = DB::table('shipments')
                    ->leftJoin('order_managements', 'order_managements.order_id', '=', 'shipments.order_id')
                    ->select('shipments.*')
                    // ->where('shipments.seller_id', '=', Auth::user()->id)
                    ->get();
            }else{
                $data = DB::table('shipments')
                    // ->leftJoin('order_managements', 'order_managements.order_id', '=', 'shipments.order_id')
                    ->select('shipments.*')
                    // ->where('shipments.seller_id', '=', Auth::user()->id)
                    ->get();
            }

            //$data = OrderManagement::latest()->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('checkbox', function ($row) {
                    return $row->id;
                })
                ->addColumn('shipment_id', function ($row) {
                    return $row->id;
                })
                ->addColumn('shipment_date', function ($row) {
                    $shipment_date = Carbon::parse($row->shipment_date)->format('d-M-Y h:i:a');
                 
                    return $shipment_date;
                })
                ->addColumn('total_item', function ($row) {
                   
                        return 3;
                 })
                 ->addColumn('print_level', function ($row) {
                    return "OK";
                 })
                 ->addColumn('pack_order', function ($row) {
                    return "OK";
                 })

                 ->addColumn('shipment_status', function ($row) {
                    if($row->shipment_status == 0){
                        return '<button type="button" class="btn btn-danger btn-sm">Not Shipped</button>';
                    }
                    if($row->shipment_status == 1){
                        return '<button type="button" class="btn btn-success btn-sm">packed</button>';
                    }
                })
                ->addColumn('created_by', function ($row) {
                    $created_at = Carbon::parse($row->created_at)->format('d-M-Y h:i:a');
                    $br="<br>";
                    return $created_at;
                })
                ->addColumn('action', function ($row) {
                  

                    return '<a  class="modal-open bg-green-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer" data-id="' . $row->id . '" id="BtnUpdate"><i class="fas fa-pencil-alt"></i></a>
                        <span class="bg-red-500 text-white rounded px-2 py-1 mr-1 capitalize cursor-pointer BtnDelete" data-id="' . $row->id . '"><i class="fas fa-trash-alt"></i></span>';
                })
                ->rawColumns(['checkbox', 'action'])
                ->make(true);
        }
    }

    public function show($id)
    {
        //
    }
}